/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.internal.motif;

import org.eclipse.swt.internal.*;

 
public class OS {

	/* Load the SWT library. */
	static {
		Library.loadLibrary ("swt");
	}

	/* OS and locale Constants*/
	public static final boolean IsAIX, IsSunOS, IsLinux, IsHPUX;
	public static final boolean IsDBLocale;
	static {
		
		/* Initialize the OS flags and locale constants */
		String osName = System.getProperty ("os.name");
		boolean isAIX = false, isSunOS = false, isLinux = false, isHPUX = false;
		if (osName.equals ("Linux")) isLinux = true;
		if (osName.equals ("AIX")) isAIX = true;
		if (osName.equals ("Solaris")) isSunOS = true;
		if (osName.equals ("SunOS")) isSunOS = true;
		if (osName.equals ("HP-UX")) isHPUX = true;
		IsAIX = isAIX;  IsSunOS = isSunOS;  IsLinux = isLinux;  IsHPUX = isHPUX;
		IsDBLocale = OS.MB_CUR_MAX () != 1;
		if (IsLinux) {
			CODESET = 14;
		} else if (IsHPUX) {
			CODESET = 62;
		} else {
			CODESET = 49;
		}
	}
	public static final int CODESET;
	public static final int LC_CTYPE = OS.IsAIX ? 1 : 0;
	
	static final int RESOURCE_LENGTH = 1024 * 3;
	static final int RESOURCE_START = OS.XtMalloc (RESOURCE_LENGTH);
	static int NextResourceStart = RESOURCE_START;
	static {
		OS.setResourceMem (RESOURCE_START, RESOURCE_START + RESOURCE_LENGTH);
	}
	
	/*
	* Added for XEventsQueued.
	*/	
//	public static final int QueuedAlready = 0;
	public static final int QueuedAfterReading = 1;
//	public static final int QueuedAfterFlush = 2
	
	/*
	* Added for XmNpopupEnabled.
	*/
//	public static final int XmPOPUP_DISABLED = 0;
//	public static final int XmPOPUP_KEYBBOARD = 1;
//	public static final int XmPOPUP_AUTOMATIC = 2;
//	public static final int XmPOPUP_AUTOMATIC_RECURSIVE = 3;
	
	/*
	* Added for XmNnavigationType.
	*/
//	public static final int XmSTICKY_TAB_GROUP = 0x2;
//	public static final int XmEXCLUSIVE_TAB_GROUP = 0x3;
		
	/*
	* Added for XtInsertEventHandler.
	*/
//	public static final int XtListHead = 0x0;
	public static final int XtListTail = 0x1;
	
	/* BEGIN Visual classes */
	//public static final int StaticGray = 0;
	//public static final int GrayScale = 1;
	//public static final int StaticColor = 2;
	//public static final int PseudoColor = 3;
	//public static final int TrueColor = 4;
	//public static final int DirectColor = 5;
	/* END Visual clases */

	/* X/Xt/Xm Constants */
	public static final byte [] XmFONTLIST_DEFAULT_TAG = {0x46, 0x4F, 0x4E, 0x54, 0x4C, 0x49, 0x53, 0x54, 0x5F, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4C, 0x54, 0x5F, 0x54, 0x41, 0x47, 0x5F, 0x53, 0x54, 0x52, 0x49, 0x4E, 0x47, 0x0};
	public static final int Above = 0;
	public static final int AllPlanes = 0xFFFFFFFF;
	public static final int AlreadyGrabbed = 1;
//	public static final int ArcChord = 0x0;
//	public static final int ArcPieSlice = 0x1;
	public static final int Below = 1;
//	public static final int BottomIf = 3;
	public static final int Button1Mask = (1<<8);
//	public static final int Button1MotionMask = 1 << 8;
	public static final int Button2Mask = (1<<9);
//	public static final int Button2MotionMask = 1 << 9;
	public static final int Button3Mask = (1<<10);
//	public static final int Button3MotionMask = 1 << 10;
//	public static final int Button4Mask = (1<<11);
//	public static final int Button4MotionMask = 1 << 11;
//	public static final int Button5Mask = (1<<12);
//	public static final int Button5MotionMask = 1 << 12;
//	public static final int ButtonMotionMask = 1 << 13;
	public static final int ButtonPress = 4;
	public static final int ButtonPressMask = 1 << 2;
	public static final int ButtonRelease = 5;
	public static final int ButtonReleaseMask = 1 << 3;
	public static final int CapButt = 0x1;
//	public static final int CapNotLast = 0x0;
//	public static final int CapProjecting = 0x3;
//	public static final int CapRound = 0x2;
//	public static final int CenterGravity = 5;
//	public static final int CirculateNotify = 26;
//	public static final int CirculateRequest = 27;
//	public static final int ClientMessage = 33;
//	public static final int ClipByChildren = 0x0;
//	public static final int ColormapChangeMask = 1 << 23;
//	public static final int ColormapNotify = 32;
	public static final int Complex = 0;
	public static final int ConfigureNotify = 22;
//	public static final int ConfigureRequest = 23;
	public static final int ControlMask = (1<<2);
	public static final int Convex = 2;
	public static final int CoordModeOrigin = 0x0;
//	public static final int CoordModePrevious = 0x1;
//	public static final int CreateNotify = 16;
	public static final int CurrentTime = 0;
//	public static final int CWBackingPixel = 0x100;
//	public static final int CWBackingPlanes = 0x80;
//	public static final int CWBackingStore = 0x40;
//	public static final int CWBackPixel = 0x2;
	public static final int CWBackPixmap = 0x1;
	public static final int CWBitGravity = 0x10;
//	public static final int CWBorderPixel = 0x8;
//	public static final int CWBorderPixmap = 0x4;
//	public static final int CWBorderWidth = 0x10;
//	public static final int CWColormap = 0x2000;
//	public static final int CWCursor = 0x4000;
	public static final int CWDontPropagate = 0x1000;
	public static final int CWEventMask = 0x800;
	public static final int CWHeight = 0x8;
//	public static final int CWOverrideRedirect = 0x200;
//	public static final int CWSaveUnder = 0x400;
	public static final int CWSibling = 0x20;
	public static final int CWStackMode = 0x40;
	public static final int CWWidth = 0x4;
//	public static final int CWWinGravity = 0x20;
//	public static final int CWX = 0x1;
//	public static final int CWY = 0x2;
//	public static final int DestroyNotify = 17;
//	public static final int EastGravity = 6;
	public static final int EnterNotify = 7;
	public static final int EnterWindowMask = 1 << 4;
//	public static final int EvenOddRule = 0x0;
	public static final int Expose = 12;
	public static final int ExposureMask = 1 << 15;
//	public static final int FillOpaqueStippled = 0x3;
//	public static final int FillSolid = 0x0;
	public static final int FillStippled = 0x2;
//	public static final int FillTiled = 0x1;
	public static final int FocusChangeMask = 1 << 21;
	public static final int FocusIn = 9;
	public static final int FocusOut = 10;
	public static final int ForgetGravity = 0;
//	public static final int GCArcMode = 0x400000;
	public static final int GCBackground = 0x8;
//	public static final int GCCapStyle = 0x40;
//	public static final int GCClipMask = 0x80000;
//	public static final int GCClipXOrigin = 0x20000;
//	public static final int GCClipYOrigin = 0x40000;
//	public static final int GCDashList = 0x200000;
//	public static final int GCDashOffset = 0x100000;
//	public static final int GCFillRule = 0x200;
//	public static final int GCFillStyle = 0x100;
//	public static final int GCFont = 0x4000;
	public static final int GCForeground = 0x4;
	public static final int GCFunction = 0x1;
//	public static final int GCGraphicsExposures = 0x10000;
//	public static final int GCJoinStyle = 0x80;
//	public static final int GCLastBit = 0x16;
//	public static final int GCLineStyle = 0x20;
	public static final int GCLineWidth = 0x10;
//	public static final int GCPlaneMask = 0x2;
//	public static final int GCStipple = 0x800;
	public static final int GCSubwindowMode = 0x8000;
//	public static final int GCTile = 0x400;
//	public static final int GCTileStipXOrigin = 0x1000;
//	public static final int GCTileStipYOrigin = 0x2000;
//	public static final int GrabFrozen = 4;
//	public static final int GrabInvalidTime = 2;
	public static final int GrabModeAsync = 1;
//	public static final int GrabModeSync = 0;
//	public static final int GrabNotViewable = 3;
	public static final int GrabSuccess = 0;
	public static final int GraphicsExpose = 13;
//	public static final int GravityNotify = 24;
	public static final int GXand = 0x1;
//	public static final int GXandInverted = 0x4;
//	public static final int GXandReverse = 0x2;
//	public static final int GXclear = 0x0;
	public static final int GXcopy = 0x3;
//	public static final int GXcopy = 0x3;
//	public static final int GXcopyInverted = 0xC;
//	public static final int GXequiv = 0x9;
//	public static final int GXinvert = 0xA;
//	public static final int GXnand = 0xE;
//	public static final int GXnoop = 0x5;
//	public static final int GXnor = 0x8;
	public static final int GXor = 0x7;
//	public static final int GXorInverted = 0xD;
//	public static final int GXorReverse = 0xB;
//	public static final int GXset = 0xF;
	public static final int GXxor = 0x6;
	public static final int IncludeInferiors = 0x1;
//	public static final int IsUnmapped = 0x0;
 	public static final int IsUnviewable = 0x1;
	public static final int IsViewable = 0x2;
//	public static final int JoinBevel = 0x2;
	public static final int JoinMiter = 0x0;
//	public static final int JoinRound = 0x1;
//	public static final int KeymapNotify = 11;
//	public static final int KeymapStateMask = 1 << 14;
	public static final int KeyPress = 2;
	public static final int KeyPressMask = 1 << 0;
	public static final int KeyRelease = 3;
	public static final int KeyReleaseMask = 1 << 1;
	public static final int LeaveNotify = 8;
	public static final int LeaveWindowMask	= 1 << 5;
	public static final int LineDoubleDash = 0x2;
	public static final int LineOnOffDash = 0x1;
	public static final int LineSolid = 0x0;
//	public static final int LockMask = (1<<1);
	public static final int LSBFirst = 0;
	public static final int MapNotify = 19;
//	public static final int MappingNotify = 34;
//	public static final int MapRequest = 20;
	public static final int Mod1Mask = (1<<3);
//	public static final int Mod2Mask = (1<<4);
//	public static final int Mod3Mask = (1<<5);
//	public static final int Mod4Mask = (1<<6);
//	public static final int Mod5Mask = (1<<7);
	public static final int MotionNotify = 6;
	public static final int MSBFirst = 1;
//	public static final int MWM_DECOR_ALL = 0x1;
	public static final int MWM_DECOR_BORDER = 0x2;
	public static final int MWM_DECOR_MAXIMIZE = 0x40;
	public static final int MWM_DECOR_MENU = 0x10;
	public static final int MWM_DECOR_MINIMIZE = 0x20;
	public static final int MWM_DECOR_RESIZEH = 0x4;
	public static final int MWM_DECOR_TITLE = 0x8;
//	public static final int MWM_FUNC_ALL = 0x1;
//	public static final int MWM_FUNC_CLOSE = 0x20;
//	public static final int MWM_FUNC_MAXIMIZE = 0x10;
//	public static final int MWM_FUNC_MINIMIZE = 0x8;
//	public static final int MWM_FUNC_MOVE = 0x4;
//	public static final int MWM_FUNC_RESIZE = 0x2;
//	public static final int MWM_HINTS_DECORATIONS = 0x2;
//	public static final int MWM_HINTS_FUNCTIONS = 0x1;
//	public static final int MWM_HINTS_INPUT_MODE = 0x4;
//	public static final int MWM_HINTS_STATUS = 0x8;
//	public static final int MWM_INFO_STARTUP_CUSTOM = 0x2;
//	public static final int MWM_INFO_STARTUP_STANDARD = 0x1;
	public static final int MWM_INPUT_FULL_APPLICATION_MODAL = 0x3;
	public static final int MWM_INPUT_MODELESS = 0x0;
	public static final int MWM_INPUT_PRIMARY_APPLICATION_MODAL = 0x1;
	public static final int MWM_INPUT_SYSTEM_MODAL = 0x2;
//	public static final int MWM_TEAR_OFF_WINDOW = 0x1;
//	public static final int NoEventMask = 0;
//	public static final int NoExpose = 14;
//	public static final int Nonconvex = 1;
	public static final int None = 0;
//	public static final int NorthEastGravity = 3;
//	public static final int NorthGravity = 2;
	public static final int NorthWestGravity = 1;
	public static final int NotifyAncestor = 0x0;
//	public static final int NotifyDetailNone = 0x7;
//	public static final int NotifyGrab = 0x1;
//	public static final int NotifyHint = 0x1;
	public static final int NotifyInferior = 0x2;
	public static final int NotifyNonlinear = 0x3;
	public static final int NotifyNonlinearVirtual = 0x4;
	public static final int NotifyNormal = 0x0;
//	public static final int NotifyPointer = 0x5;
//	public static final int NotifyPointerRoot = 0x6;
//	public static final int NotifyUngrab = 0x2;
//	public static final int NotifyVirtual = 0x1;
//	public static final int NotifyWhileGrabbed = 0x3;
//	public static final int Opposite = 4;
//	public static final int OwnerGrabButtonMask = 1 << 24;
//	public static final int PointerMotionHintMask = 1 << 7;
	public static final int PointerMotionMask = 1 << 6;
//	public static final int PropertyChangeMask = 1 << 22;
//	public static final int PropertyNotify = 28;
//	public static final int RectangleIn = 0x1;
	public static final int RectangleOut = 0x0;
//	public static final int RectanglePart = 0x2;
	public static final int ReparentNotify = 21;
	public static final int ResizeRedirectMask = 1 << 18;
//	public static final int ResizeRequest = 25;
//	public static final int RevertToNone = 0x0;
	public static final int RevertToParent = 0x2;
//	public static final int RevertToPointerRoot = 0x1;
//	public static final int SelectionClear = 29;
//	public static final int SelectionNotify = 31;
//	public static final int SelectionRequest = 30;
	public static final int ShiftMask = (1<<0);
//	public static final int SouthEastGravity = 9;
//	public static final int SouthGravity = 8;
//	public static final int SouthWestGravity = 7;
//	public static final int StaticGravity = 10;
	public static final int StructureNotifyMask = 1 << 17;
	public static final int SubstructureNotifyMask = 1 << 19;
	public static final int SubstructureRedirectMask = 1 << 20;
//	public static final int TopIf = 2;
	public static final int UnmapNotify = 18;
	public static final int Unsorted = 0x0;
//	public static final int VisibilityChangeMask = 1 << 16;
//	public static final int VisibilityNotify = 15;
//	public static final int WestGravity = 4;
//	public static final int WindingRule = 0x1;
	public static final int XA_FONT = 18;
	public static final int XBufferOverflow = 0xFFFFFFFF;
	public static final int XCompoundTextStyle = 1;
//	public static final int XC_arrow = 2;
//	public static final int XC_based_arrow_down = 4;
//	public static final int XC_based_arrow_up = 6;
//	public static final int XC_boat = 8;
//	public static final int XC_bogosity= 10;
	public static final int XC_bottom_left_corner = 12;
	public static final int XC_bottom_right_corner = 14;
	public static final int XC_bottom_side = 16;
//	public static final int XC_bottom_tee = 18;
//	public static final int XC_box_spiral = 20;
//	public static final int XC_center_ptr = 22;
//	public static final int XC_circle = 24;
//	public static final int XC_clock = 26;
//	public static final int XC_coffee_mug = 28;
	public static final int XC_cross = 30;
//	public static final int XC_cross_reverse = 32;
//	public static final int XC_crosshair = 34;
	public static final int XC_diamond_cross = 36;
//	public static final int XC_dot = 38;
//	public static final int XC_dotbox = 40;
	public static final int XC_double_arrow = 42;
//	public static final int XC_draft_large = 44;
//	public static final int XC_draft_small = 46;
//	public static final int XC_draped_box = 48;
//	public static final int XC_exchange = 50;
//	public static final int XC_fleur = 52;
//	public static final int XC_gobbler = 54;
//	public static final int XC_gumby = 56;
//	public static final int XC_hand1 = 58;
	public static final int XC_hand2 = 60;
//	public static final int XC_heart = 62;
//	public static final int XC_icon = 64;
//	public static final int XC_iron_cross = 66;
	public static final int XC_left_ptr = 68;
	public static final int XC_left_side = 70;
//	public static final int XC_left_tee = 72;
//	public static final int XC_leftbutton = 74;
//	public static final int XC_ll_angle = 76;
//	public static final int XC_lr_angle = 78;
//	public static final int XC_man = 80;
//	public static final int XC_middlebutton = 82;
//	public static final int XC_mouse = 84;
//	public static final int XC_num_glyphs = 154;
//	public static final int XC_pencil = 86;
//	public static final int XC_pirate = 88;
//	public static final int XC_plus = 90;
	public static final int XC_question_arrow = 92;
//	public static final int XC_right_ptr = 94;
	public static final int XC_right_side = 96;
//	public static final int XC_right_tee = 98;
//	public static final int XC_rightbutton = 100;
//	public static final int XC_rtl_logo = 102;
//	public static final int XC_sailboat = 104;
//	public static final int XC_sb_down_arrow = 106;
	public static final int XC_sb_h_double_arrow = 108;
//	public static final int XC_sb_left_arrow = 110;
//	public static final int XC_sb_right_arrow = 112;
	public static final int XC_sb_up_arrow = 114;
	public static final int XC_sb_v_double_arrow = 116;
//	public static final int XC_shuttle = 118;
	public static final int XC_sizing = 120;
//	public static final int XC_spider = 122;
//	public static final int XC_spraycan = 124;
//	public static final int XC_star = 126;
//	public static final int XC_target = 128;
//	public static final int XC_tcross = 130;
//	public static final int XC_top_left_arrow = 132;
	public static final int XC_top_left_corner = 134;
	public static final int XC_top_right_corner = 136;
	public static final int XC_top_side = 138;
//	public static final int XC_top_tee = 140;
//	public static final int XC_trek = 142;
//	public static final int XC_ul_angle = 144;
//	public static final int XC_umbrella = 146;
//	public static final int XC_ur_angle = 148;
	public static final int XC_watch = 150;
	public static final int XC_X_cursor = 0;
	public static final int XC_xterm = 152;
	public static final int XK_Alt_L = 0xFFE9;
	public static final int XK_Alt_R = 0xFFEA;
	public static final int XK_BackSpace = 0xFF08;
	public static final int XK_Cancel = 0xFF69;
	public static final int XK_Control_L = 0xFFE3;
	public static final int XK_Control_R = 0xFFE4;
	public static final int XK_Delete = 0xFFFF;
	public static final int XK_Down = 0xFF54;
	public static final int XK_End = 0xFF57;
	public static final int XK_Escape = 0xFF1B;
	public static final int XK_F1 = 0xFFBE;
	public static final int XK_F10 = 0xFFC7;
	public static final int XK_F11 = 0xFFC8;
	public static final int XK_F12 = 0xFFC9;
	public static final int XK_F2 = 0xFFBF;
	public static final int XK_F3 = 0xFFC0;
	public static final int XK_F4 = 0xFFC1;
	public static final int XK_F5 = 0xFFC2;
	public static final int XK_F6 = 0xFFC3;
	public static final int XK_F7 = 0xFFC4;
	public static final int XK_F8 = 0xFFC5;
	public static final int XK_F9 = 0xFFC6;
	public static final int XK_Home = 0xFF50;
	public static final int XK_Insert = 0xFF63;
	public static final int XK_ISO_Left_Tab = 0xFE20;
//	public static final int XK_KP_0 = 0xFFB0;
//	public static final int XK_KP_1 = 0xFFB1;
//	public static final int XK_KP_2 = 0xFFB2;
//	public static final int XK_KP_3 = 0xFFB3;
//	public static final int XK_KP_4 = 0xFFB4;
//	public static final int XK_KP_5 = 0xFFB5;
//	public static final int XK_KP_6 = 0xFFB6;
//	public static final int XK_KP_7 = 0xFFB7;
//	public static final int XK_KP_8 = 0xFFB8;
//	public static final int XK_KP_9 = 0xFFB9;
//	public static final int XK_KP_Add = 0xFFAB;
//	public static final int XK_KP_Decimal = 0xFFAE;
//	public static final int XK_KP_Divide = 0xFFAF;
	public static final int XK_KP_Enter = 0xFF8D;
//	public static final int XK_KP_Multiply = 0xFFAA;
//	public static final int XK_KP_Subtract = 0xFFAD;
	public static final int XK_Left = 0xFF51;
	public static final int XK_Linefeed = 0xFF0A;
	public static final int XK_Page_Down = 0xFF56;
	public static final int XK_Page_Up = 0xFF55;
	public static final int XK_Right = 0xFF53;
	public static final int XK_Return = 0xFF0D;
	public static final int XK_Shift_L = 0xFFE1;
	public static final int XK_Shift_R = 0xFFE2;
	public static final int XK_space = 0x20;
	public static final int XK_Tab = 0xFF09;
	public static final int XK_Up = 0xFF52;
	public static final int XK_VoidSymbol = 0xFFFFFF;
//	public static final int XLookupBoth = 0x4;
//	public static final int XLookupChars = 0x2;
//	public static final int XLookupKeySym = 0x3;
//	public static final int XLookupNone = 0x1;
	public static final int XStringStyle = 0;
	public static final int XmALIGNMENT_BEGINNING = 0x0;
	public static final int XmALIGNMENT_CENTER = 0x1;
	public static final int XmALIGNMENT_END = 0x2;
	public static final int XmARROW_DOWN = 0x1;
	public static final int XmARROW_LEFT = 0x2;
	public static final int XmARROW_RIGHT = 0x3;
	public static final int XmARROW_UP = 0x0;
//	public static final int XmARROWS_END = 0x0;
//	public static final int XmAS_NEEDED = 0x1;
//	public static final int XmATTACH_CENTER = 0x8;
//	public static final int XmATTACH_EAST = 0x3;
	public static final int XmATTACH_FORM = 0x1;
//	public static final int XmATTACH_HOT = 0x9;
//	public static final int XmATTACH_NONE = 0x0;
//	public static final int XmATTACH_NORTH = 0x1;
//	public static final int XmATTACH_NORTH_EAST = 0x2;
//	public static final int XmATTACH_NORTH_WEST = 0x0;
//	public static final int XmATTACH_OPPOSITE_FORM = 0x2;
//	public static final int XmATTACH_OPPOSITE_WIDGET = 0x4;
//	public static final int XmATTACH_POSITION = 0x5;
//	public static final int XmATTACH_SELF = 0x6;
//	public static final int XmATTACH_SOUTH = 0x5;
//	public static final int XmATTACH_SOUTH_EAST = 0x4;
//	public static final int XmATTACH_SOUTH_WEST = 0x6;
//	public static final int XmATTACH_WEST = 0x7;
//	public static final int XmATTACH_WIDGET = 0x3;
	public static final int XmBLEND_ALL = 0x0;
	public static final int XmBROWSE_SELECT = 0x3;
	public static final int XmCHARSET_TEXT = 0x0;
	public static final int XmClipboardFail = 0x0;
	public static final int XmClipboardSuccess = 0x1;
	public static final int XmClipboardLocked = 0x4;
	public static final int XmClipboardNoData = 0x6;
	public static final int XmCOMBO_BOX = 0x0;
	public static final int XmCONSTANT = 0x1;
	public static final int XmCOPY_FAILED = 0x0;
//	public static final int XmCOPY_SUCCEEDED = 0x1;
	public static final int XmCOPY_TRUNCATED = 0x2;
//	public static final int XmCR_ACTIVATE = 0xA;
//	public static final int XmCR_APPLY = 0x22;
//	public static final int XmCR_ARM = 0xB;
//	public static final int XmCR_BROWSE_SELECT = 0x1A;
//	public static final int XmCR_CANCEL = 0x20;
//	public static final int XmCR_CASCADING = 0x1E;
//	public static final int XmCR_CLIPBOARD_DATA_DELETE = 0x1D;
//	public static final int XmCR_CLIPBOARD_DATA_REQUEST = 0x1C;
//	public static final int XmCR_COMMAND_CHANGED = 0x25;
//	public static final int XmCR_COMMAND_ENTERED = 0x24;
//	public static final int XmCR_CREATE = 0x2B;
	public static final int XmCR_DECREMENT = 0x4;
//	public static final int XmCR_DEFAULT_ACTION = 0x1B;
//	public static final int XmCR_DISARM = 0xC;
	public static final int XmCR_DRAG = 0x9;
//	public static final int XmCR_DRAGDROP_FINISH = 0x7;
//	public static final int XmCR_DRAG_MOTION = 0x2;
//	public static final int XmCR_DROP_FINISH = 0x6;
//	public static final int XmCR_DROP_MESSAGE = 0x4;
//	public static final int XmCR_DROP_SITE_ENTER = 0x3;
	public static final int XmCR_DROP_SITE_ENTER_MESSAGE = 0x2;
//	public static final int XmCR_DROP_SITE_LEAVE = 0x4;
	public static final int XmCR_DROP_SITE_LEAVE_MESSAGE = 0x1;
	public static final int XmCR_DROP_SITE_MOTION_MESSAGE = 0x3;
//	public static final int XmCR_DROP_START = 0x5;
//	public static final int XmCR_EXECUTE = 0x16;
//	public static final int XmCR_EXPOSE = 0x26;
//	public static final int XmCR_EXTENDED_SELECT = 0x19;
//	public static final int XmCR_FOCUS = 0x12;
//	public static final int XmCR_GAIN_PRIMARY = 0x29;
//	public static final int XmCR_HELP = 0x1;
	public static final int XmCR_INCREMENT = 0x3;
//	public static final int XmCR_INPUT = 0x28;
//	public static final int XmCR_LOSE_PRIMARY = 0x2A;
//	public static final int XmCR_LOSING_FOCUS = 0x13;
//	public static final int XmCR_MAP = 0x10;
//	public static final int XmCR_MODIFYING_TEXT_VALUE = 0x14;
//	public static final int XmCR_MOVING_INSERT_CURSOR = 0x15;
//	public static final int XmCR_MULTIPLE_SELECT = 0x18;
//	public static final int XmCR_NO_MATCH = 0x23;
//	public static final int XmCR_NONE = 0x0;
//	public static final int XmCR_OBSCURED_TRAVERSAL = 0x2E;
//	public static final int XmCR_OK = 0x1F;
	public static final int XmCR_OPERATION_CHANGED = 0x8;
	public static final int XmCR_PAGE_DECREMENT = 0x6;
	public static final int XmCR_PAGE_INCREMENT = 0x5;
//	public static final int XmCR_PROTOCOLS = 0x2F;
//	public static final int XmCR_RESIZE = 0x27;
//	public static final int XmCR_SINGLE_SELECT = 0x17;
//	public static final int XmCR_TEAR_OFF_ACTIVATE = 0x2C;
//	public static final int XmCR_TEAR_OFF_DEACTIVATE = 0x2D;
	public static final int XmCR_TO_BOTTOM = 0x8;
//	public static final int XmCR_TOP_LEVEL_ENTER = 0x0;
//	public static final int XmCR_TOP_LEVEL_LEAVE = 0x1;
	public static final int XmCR_TO_TOP = 0x7;
//	public static final int XmCR_UNMAP = 0x11;
	public static final int XmCR_VALUE_CHANGED = 0x2;
//	public static final int XmCR_WMPROTOCOLS = 0x1A0A;
	public static final int XmDEFAULT_SELECT_COLOR = -1;
//	public static final int XmDESTROY = 0x0;
	public static final int XmDIALOG_APPLICATION_MODAL = 0x1;
	public static final int XmDIALOG_APPLY_BUTTON = 0x1;
	public static final int XmDIALOG_CANCEL_BUTTON = 0x2;
//	public static final int XmDIALOG_COMMAND = 0x3;
//	public static final int XmDIALOG_COMMAND_TEXT = 0xD;
//	public static final int XmDIALOG_DEFAULT_BUTTON = 0x3;
//	public static final int XmDIALOG_DIR_LIST = 0xF;
//	public static final int XmDIALOG_DIR_LIST_LABEL = 0x10;
//	public static final int XmDIALOG_ERROR = 0x1;
//	public static final int XmDIALOG_FILE_LIST = 0x8;
//	public static final int XmDIALOG_FILE_LIST_LABEL = 0x9;
//	public static final int XmDIALOG_FILE_SELECTION = 0x4;
	public static final int XmDIALOG_FILTER_LABEL = 0x5;
	public static final int XmDIALOG_FILTER_TEXT = 0x6;
	public static final int XmDIALOG_FULL_APPLICATION_MODAL = 0x2;
	public static final int XmDIALOG_HELP_BUTTON = 0x7;
//	public static final int XmDIALOG_HISTORY_LIST = 0x8;
//	public static final int XmDIALOG_INFORMATION = 0x2;
	public static final int XmDIALOG_LIST = 0x8;
	public static final int XmDIALOG_LIST_LABEL = 0x9;
//	public static final int XmDIALOG_MESSAGE = 0x3;
	public static final int XmDIALOG_MESSAGE_LABEL = 0xA;
	public static final int XmDIALOG_MODELESS = 0x0;
//	public static final int XmDIALOG_NONE = 0x0;
	public static final int XmDIALOG_OK_BUTTON = 0x4;
	public static final int XmDIALOG_PRIMARY_APPLICATION_MODAL = 0x1;
//	public static final int XmDIALOG_PROMPT = 0x1;
//	public static final int XmDIALOG_PROMPT_LABEL = 0xB;
//	public static final int XmDIALOG_QUESTION = 0x4;
//	public static final int XmDIALOG_SELECTION = 0x2;
	public static final int XmDIALOG_SELECTION_LABEL = 0xB;
//	public static final int XmDIALOG_SEPARATOR = 0xE;
//	public static final int XmDIALOG_SYMBOL_LABEL = 0xC;
	public static final int XmDIALOG_SYSTEM_MODAL = 0x3;
//	public static final int XmDIALOG_TEMPLATE = 0x0;
	public static final int XmDIALOG_TEXT = 0xD;
//	public static final int XmDIALOG_VALUE_TEXT = 0xD;
//	public static final int XmDIALOG_WARNING = 0x5;
//	public static final int XmDIALOG_WORK_AREA = 0x0;
//	public static final int XmDIALOG_WORKING = 0x6;
	public static final int XmDO_NOTHING = 0x2;
//	public static final int XmDOUBLE_DASHED_LINE = 0x4;
//	public static final int XmDOUBLE_LINE = 0x2;
	public static final int XmDRAG_DYNAMIC = 5;
	public static final int XmDRAG_UNDER_NONE = 0;
	public static final byte XmDROP_COPY = (1 << 1);
	public static final int XmDROP_DOWN_COMBO_BOX = 0x1;
	public static final int XmDROP_DOWN_LIST = 0x2;	
	public static final byte XmDROP_LINK = (1 << 2);
	public static final byte XmDROP_MOVE = (1 << 0);
	public static final byte XmDROP_NOOP = 0;
	public static final int XmDROP_SITE_ACTIVE = 0;
	public static final int XmDROP_SITE_INACTIVE = 1;
	public static final int XmDROP_SITE_INVALID = 2;
	public static final int XmDROP_SITE_VALID = 3;
	public static final int XmDROP_SITE_COMPOSITE = 1;
	public static final byte XmDROP = 0;
	public static final int XmEXTENDED_SELECT = 0x2;
	public static final int XmFONT_IS_FONT = 0x0;
	public static final int XmFONT_IS_FONTSET = 0x1;
	public static final int XmFOREGROUND_COLOR = 0x1;
//	public static final int XmFRAME_GENERIC_CHILD = 0x0;
	public static final int XmFRAME_TITLE_CHILD = 0x2;
//	public static final int XmFRAME_WORKAREA_CHILD = 0x1;
	public static final int XmHIGHLIGHT_COLOR = -3;
	public static final int XmHIGHLIGHT_NORMAL = 0x0;
//	public static final int XmHIGHLIGHT_SECONDARY_SELECTED = 0x2;
//	public static final int XmHIGHLIGHT_SELECTED = 0x1;
	public static final int XmHORIZONTAL = 0x2;
	public static final int XmLAST_POSITION = -1;
	public static final int XmMAX_ON_BOTTOM = 0x1;
//	public static final int XmMAX_ON_LEFT = 0x2;
	public static final int XmMAX_ON_RIGHT = 0x3;
	public static final int XmMAX_ON_TOP = 0x0;
	public static final int XmMERGE_REPLACE = 0x1;
	public static final int XmMULTI_LINE_EDIT = 0x0;
	public static final int XmMULTIPLE_SELECT = 0x1;
	public static final int XmN_OF_MANY = 0x1;
	public static final int XmNONE = 0x0;
//	public static final int XmNUMERIC = 0x3;
	public static final int XmPATH_MODE_FULL = 0x0;
//	public static final int XmPATH_MODE_RELATIVE = 0x1;

	/* byte */
	public static final int XmNancestorSensitive = malloc ("ancestorSensitive", 1);
	public static final int XmNanimationStyle = malloc ("animationStyle", 1);
	public static final int XmNalignment = malloc ("alignment", 1);
	public static final int XmNallowShellResize = malloc ("allowShellResize", 1);
	public static final int XmNarrowDirection = malloc ("arrowDirection", 1);
	public static final int XmNblendModel = malloc ("blendModel", 1);
	public static final int XmNbottomAttachment = malloc ("bottomAttachment", 1);
	public static final int XmNcomboBoxType = malloc ("comboBoxType", 1);
	public static final int XmNdialogStyle = malloc ("dialogStyle", 1);
	public static final int XmNcursorPositionVisible = malloc ("cursorPositionVisible", 1);
	public static final int XmNdeleteResponse = malloc ("deleteResponse", 1);
	public static final int XmNdragInitiatorProtocolStyle = malloc ("dragInitiatorProtocolStyle", 1);
	public static final int XmNdragReceiverProtocolStyle = malloc ("dragReceiverProtocolStyle", 1);
	public static final int XmNdragOperations = malloc ("dragOperations", 1);
	public static final int XmNdropSiteActivity = malloc ("dropSiteActivity", 1);
	public static final int XmNdropSiteOperations = malloc ("dropSiteOperations", 1);
	public static final int XmNdropSiteType = malloc ("dropSiteType", 1);
	public static final int XmNeditable = malloc ("editable", 1);
	public static final int XmNenableThinThickness = malloc ("enableThinThickness", 1);
	public static final int XmNfillOnSelect = malloc ("fillOnSelect", 1);
	public static final int XmNframeChildType = malloc ("frameChildType", 1);
	public static final int XmNiconic = malloc ("iconic", 1);
	public static final int XmNlabelType = malloc ("labelType", 1);
	public static final int XmNleftAttachment = malloc ("leftAttachment", 1);
	public static final int XmNlistSizePolicy = malloc ("listSizePolicy", 1);
	public static final int XmNindicatorOn = malloc ("indicatorOn", 1);
	public static final int XmNindicatorType = malloc ("indicatorType", 1);
	public static final int XmNnoResize = malloc ("noResize", 1);
	public static final int XmNorientation = malloc ("orientation", 1);
	public static final int XmNoverrideRedirect = malloc ("overrideRedirect", 1);
	public static final int XmNprocessingDirection = malloc ("processingDirection", 1);
	public static final int XmNrecomputeSize = malloc ("recomputeSize", 1);
	public static final int XmNpushButtonEnabled = malloc ("pushButtonEnabled", 1);
	public static final int XmNresizable = malloc ("resizable", 1);
	public static final int XmNresizePolicy = malloc ("resizePolicy", 1);
	public static final int XmNrightAttachment = malloc ("rightAttachment", 1);
	public static final int XmNscrollHorizontal = malloc ("scrollHorizontal", 1);
	public static final int XmNscrollVertical = malloc ("scrollVertical", 1);
	public static final int XmNselectColor = malloc ("selectColor", 1);
	public static final int XmNselectionPolicy = malloc ("selectionPolicy", 1);
	public static final int XmNsensitive = malloc ("sensitive", 1);
	public static final int XmNseparatorType = malloc ("separatorType", 1);
	public static final int XmNset = malloc ("set", 1);
	public static final int XmNshadowType = malloc ("shadowType", 1);
	public static final int XmNtraversalOn = malloc ("traversalOn", 1);
	public static final int XmNtopAttachment = malloc ("topAttachment", 1);
	public static final int XmNverifyBell = malloc ("verifyBell", 1);
	public static final int XmNwordWrap = malloc ("wordWrap", 1);
	public static final int XmNnavigationType = malloc ("navigationType", 1);
		
	/* short */
	public static final int XmNarrowSize = malloc ("arrowSize", 2);
	public static final int XmNarrowSpacing = malloc ("arrowSpacing", 2);
	public static final int XmNborderWidth = malloc ("borderWidth", 2);
	public static final int XmNchildHorizontalSpacing = malloc ("childHorizontalSpacing", 2);
	public static final int XmNheight = malloc ("height", 2);
	public static final int XmNhighlightThickness = malloc ("highlightThickness", 2);
	public static final int XmNlistMarginHeight = malloc ("listMarginHeight", 2);
	public static final int XmNlistMarginWidth = malloc ("listMarginWidth", 2);
	public static final int XmNlistSpacing = malloc ("listSpacing", 2);
	public static final int XmNmarginBottom = malloc ("marginBottom", 2);
	public static final int XmNmarginHeight = malloc ("marginHeight", 2);
	public static final int XmNmarginLeft = malloc ("marginLeft", 2);
	public static final int XmNmarginRight = malloc ("marginRight", 2);
	public static final int XmNmarginTop = malloc ("marginTop", 2);
	public static final int XmNmarginWidth = malloc ("marginWidth", 2);
	public static final int XmNpositionIndex = malloc ("positionIndex", 2);
	public static final int XmNrows = malloc ("rows", 2);
	public static final int XmNshadowThickness = malloc ("shadowThickness", 2);
	public static final int XmNshowAsDefault = malloc ("showAsDefault", 2);
	public static final int XmNwidth = malloc ("width", 2);
	public static final int XmNx = malloc ("x", 2);
	public static final int XmNy = malloc ("y", 2);
			
	/* int */
	public static final int XmNaccelerator = malloc ("accelerator", 4);
	public static final int XmNacceleratorText = malloc ("acceleratorText", 4);
	public static final int XmNactivateCallback = malloc ("activateCallback", 4);
	public static final int XmNarmCallback = malloc ("armCallback", 4);
	public static final int XmNbackground = malloc ("background", 4);
	public static final int XmNborderColor = malloc ("borderColor", 4);
	public static final int XmNbottomShadowColor = malloc ("bottomShadowColor", 4);
	public static final int XmNbrowseSelectionCallback = malloc ("browseSelectionCallback", 4);
	public static final int XmNcancelCallback = malloc ("cancelCallback", 4);
	public static final int XmNcancelLabelString = malloc ("cancelLabelString", 4);
	public static final int XmNcascadingCallback = malloc ("cascadingCallback", 4);
	public static final int XmNchildren = malloc ("children", 4);
	public static final int XmNclientData = malloc ("clientData", 4);
	public static final int XmNcolormap = malloc ("colormap", 4);
	public static final int XmNconvertProc = malloc ("convertProc", 4);
	public static final int XmNdecrementCallback = malloc ("decrementCallback", 4);
	public static final int XmNdefaultActionCallback = malloc ("defaultActionCallback", 4);
	public static final int XmNdefaultButtonShadowThickness = malloc ("defaultButtonShadowThickness", 4);
	public static final int XmNdialogTitle = malloc ("dialogTitle", 4);
	public static final int XmNdirectory = malloc ("directory", 4);
	public static final int XmNdirMask = malloc ("dirMask", 4);
	public static final int XmNdirSpec = malloc ("dirSpec", 4);
	public static final int XmNdragCallback = malloc ("dragCallback", 4);
	public static final int XmNdragDropFinishCallback = malloc ("dragDropFinishCallback", 4);
	public static final int XmNdragProc = malloc ("dragProc", 4);
	public static final int XmNdropFinishCallback = malloc ("dropFinishCallback", 4);
	public static final int XmNdropProc = malloc("dropProc", 4);
	public static final int XmNeditMode = malloc ("editMode", 4);
	public static final int XmNexportTargets = malloc ("exportTargets", 4);
	public static final int XmNexposeCallback = malloc ("exposeCallback", 4);
	public static final int XmNextendedSelectionCallback = malloc ("extendedSelectionCallback", 4);
	public static final int XmNfilterLabelString = malloc ("filterLabelString", 4);
	public static final int XmNfont = malloc ("font", 4);
	public static final int XmNfontList = malloc ("fontList", 4);
	public static final int XmNfontType = malloc ("fontType", 4);
	public static final int XmNforeground = malloc ("foreground", 4);
	public static final int XmNhelpCallback = malloc ("helpCallback", 4);
	public static final int XmNhelpLabelString = malloc ("helpLabelString", 4);
	public static final int XmNhighlightColor = malloc ("highlightColor", 4);
	public static final int XmNhorizontalScrollBar = malloc ("horizontalScrollBar", 4);
	public static final int XmNiconMask = malloc ("iconMask", 4);
	public static final int XmNiconPixmap = malloc ("iconPixmap", 4);
	public static final int XmNincrement = malloc ("increment", 4);
	public static final int XmNincrementCallback = malloc ("incrementCallback", 4);
	public static final int XmNitemCount = malloc ("itemCount", 4);
	public static final int XmNitems = malloc ("items", 4);
	public static final int XmNlabelInsensitivePixmap = malloc ("labelInsensitivePixmap", 4);
	public static final int XmNlabelPixmap = malloc ("labelPixmap", 4);
	public static final int XmNlabelString = malloc ("labelString", 4);
	public static final int XmNlist = malloc ("list", 4);
	public static final int XmNmapCallback = malloc ("mapCallback", 4);
	public static final int XmNmappedWhenManaged = malloc ("mappedWhenManaged", 4);
	public static final int XmNmaximum = malloc ("maximum", 4); 
	public static final int XmNmenuBar = malloc ("menuBar", 4);
	public static final int XmNmessageString = malloc ("messageString", 4);
	public static final int XmNminimum = malloc ("minimum", 4);
	public static final int XmNmodifyVerifyCallback = malloc ("modifyVerifyCallback", 4);
	public static final int XmNmwmDecorations = malloc ("mwmDecorations", 4);
	public static final int XmNmwmInputMode = malloc ("mwmInputMode", 4);
	public static final int XmNnumChildren = malloc ("numChildren", 4);
	public static final int XmNnumDropTransfers = malloc ("numDropTransfers", 4);
	public static final int XmNnumExportTargets = malloc ("numExportTargets", 4);
	public static final int XmNnumImportTargets = malloc("numImportTargets", 4);
	public static final int XmNmnemonic = malloc ("mnemonic", 4);
	public static final int XmNimportTargets = malloc("importTargets", 4);
	public static final int XmNokCallback = malloc ("okCallback", 4);
	public static final int XmNokLabelString = malloc ("okLabelString", 4);
	public static final int XmNoperationCursorIcon = malloc ("operationCursorIcon", 4);
	public static final int XmNselectionCallback = malloc ("selectionCallback", 4);
	public static final int XmNsourceCursorIcon = malloc ("sourceCursorIcon", 4);
	public static final int XmNstateCursorIcon = malloc ("stateCursorIcon", 4);
	public static final int XmNsubstitute = malloc ("substitute", 4);
	public static final int XmNpageDecrementCallback = malloc ("pageDecrementCallback", 4);
	public static final int XmNpageIncrement = malloc ("pageIncrement", 4);
	public static final int XmNpageIncrementCallback = malloc ("pageIncrementCallback", 4);
	public static final int XmNpathMode = malloc ("pathMode", 4);
	public static final int XmNpattern = malloc ("pattern", 4);
//	public static final int XmNpopupEnabled = malloc ("popupEnabled", 4);
//	public static final int XmNpopupHandlerCallback = malloc ("popupHandlerCallback", 4);
	public static final int XmNrenderTable = malloc ("renderTable", 4);
	public static final int XmNscaleMultiple = malloc ("scaleMultiple", 4);
	public static final int XmNselectedItemCount = malloc ("selectedItemCount", 4);
	public static final int XmNselectedItems = malloc ("selectedItems", 4);
	public static final int XmNselectedPosition = malloc ("selectedPosition", 4);
	public static final int XmNselectionArrayCount = malloc ("selectionArrayCount", 4);
	public static final int XmNsliderSize = malloc ("sliderSize", 4);
	public static final int XmNsliderVisual = malloc ("sliderVisual", 4);
	public static final int XmNsubMenuId = malloc ("subMenuId", 4);
	public static final int XmNtabList = malloc ("tabList", 4);
	public static final int XmNtextField = malloc ("textField", 4);
	public static final int XmNtitle = malloc ("title", 4);
	public static final int XmNtitleString = malloc ("titleString", 4);
	public static final int XmNtoBottomCallback = malloc ("toBottomCallback", 4);
	public static final int XmNtoTopCallback = malloc ("toTopCallback", 4);
//	public static final int XmNtopCharacter = malloc ("topCharacter", 4);
	public static final int XmNtopItemPosition = malloc ("topItemPosition", 4);
	public static final int XmNtopShadowColor = malloc ("topShadowColor", 4);
	public static final int XmNtransferProc = malloc ("transferProc", 4);
	public static final int XmNtransferStatus = malloc ("transferStatus", 4);
	public static final int XmNtroughColor = malloc ("troughColor", 4);
	public static final int XmNunmapCallback = malloc ("unmapCallback", 4);
	public static final int XmNuserData = malloc ("userData", 4);
	public static final int XmNvalue = malloc ("value", 4);
	public static final int XmNvalueChangedCallback = malloc ("valueChangedCallback", 4);
	public static final int XmNverticalScrollBar = malloc ("verticalScrollBar", 4);
	public static final int XmNvisibleItemCount = malloc ("visibleItemCount", 4);
	public static final int XmNdropTransfers  = malloc ("dropTransfers", 4);
	public static final int XmNshowArrows = malloc ("showArrows", 4);
	public static final int XmNspotLocation = malloc ("spotLocation", 4);
	public static final int XmNarea = malloc ("area", 4);
//	public static final int XNFocusWindow = malloc ("focusWindow", 4);
//	public static final int XNInputStyle = malloc ("inputStyle", 4);
//	public static final int XNClientWindow = malloc ("clientWindow", 4);
//	public static final int XNQueryInputStyle = malloc ("queryInputStyle", 4);
			
	public static final int XmNO_LINE = 0x0;
	public static final int XmONE_OF_MANY = 0x2;
	public static final int XmOUTPUT_ALL = 0x0;
	public static final int XmPIXELS = 0x0;
	public static final int XmPIXMAP = 0x1;
	public static final int XmRELATIVE = 0x1;
//	public static final int XmRESIZE_ANY = 0x2;
//	public static final int XmRESIZE_GROW = 0x1;
//	public static final int XmRESIZE_IF_POSSIBLE = 0x2;
	public static final int XmRESIZE_NONE = 0x0;
	public static final int XmREVERSED_GROUND_COLORS = -2;
	public static final int XmSET = 0x1;
	public static final int XmSHADOW_ETCHED_IN = 0x5;
//	public static final int XmSHADOW_ETCHED_IN_DASH = 0x7;
	public static final int XmSHADOW_ETCHED_OUT = 0x6;
//	public static final int XmSHADOW_ETCHED_OUT_DASH = 0x8;
	public static final int XmSHADOW_IN = 0x7;
	public static final int XmSHADOW_OUT = 0x8;
//	public static final int XmSINGLE_DASHED_LINE = 0x3;
//	public static final int XmSINGLE_LINE = 0x1;
	public static final int XmSINGLE_LINE_EDIT = 0x1;
//	public static final int XmSINGLE_SELECT = 0x0;
//	public static final int XmSPIN_NEXT = 0x3E;
//	public static final int XmSPIN_PRIOR = 0x3F;
//	public static final int XmSTATIC = 0x0;
	public static final int XmSTRING = 0x2;
	public static final int XmSTRING_COMPONENT_SEPARATOR = 0x4;
	public static final int XmSTRING_COMPONENT_TAB = 0xC;	
//	public static final int XmTAB_GROUP = 0x1;
	public static final int XmTRANSFER_FAILURE = 0;
	public static final int XmTRAVERSE_CURRENT = 0x0;
//	public static final int XmTRAVERSE_DOWN = 0x7;
//	public static final int XmTRAVERSE_HOME = 0x3;
//	public static final int XmTRAVERSE_LEFT = 0x8;
//	public static final int XmTRAVERSE_NEXT = 0x1;
//	public static final int XmTRAVERSE_NEXT_TAB_GROUP = 0x4;
//	public static final int XmTRAVERSE_PREV = 0x2;
//	public static final int XmTRAVERSE_PREV_TAB_GROUP = 0x5;
//	public static final int XmTRAVERSE_RIGHT = 0x9;
//	public static final int XmTRAVERSE_UP = 0x6;
//	public static final int XmUNMAP = 0x1;
	public static final int XmUNSET = 0x0;
	public static final int XmUNSPECIFIED_PIXMAP = 0x2;
	public static final int XmVARIABLE = 0x0;
	public static final int XmVERTICAL = 0x1;
//	public static final int XtCWQueryOnly = 128;
//	public static final int XtGeometryAlmost = 0x2;
//	public static final int XtGeometryDone = 0x3;
//	public static final int XtGeometryNo = 0x1;
//	public static final int XtGeometryYes = 0x0;
//	public static final int XtGrabExclusive = 0x2;
	public static final int XtGrabNone = 0x0;
//	public static final int XtGrabNonexclusive = 0x1;
//	public static final int XtIMAll = 0x7;
	public static final int XtIMAlternateInput = 0x4;
	public static final int XtIMTimer = 0x2;
	public static final int XtIMXEvent = 0x1;
	public static final int XYBitmap = 0;
//	public static final int XYPixmap = 1;
//	public static final int YSorted = 0x1;
//	public static final int YXBanded = 0x3;
//	public static final int YXSorted = 0x2;
	public static final int ZPixmap = 2;

	/* Unused X Structs */
	/*
	public class XPoint {
		public short x, y;
		public static final int sizeof = 4;
	}
	*/

	/* Unused Natives */
	/*
	public static final synchronized native int XBlackPixel (int display, int screenNum);
	public static final synchronized native void XChangeActivePointerGrab (int display, int eventMask, int cursor, int time);
	public static final synchronized native int XDefaultGC (int display, int screen_number);
	public static final synchronized native void XNoOp (int display);
	public static final synchronized native int XRootWindowOfScreen (int screen);
	public static final synchronized native int XSendEvent (int display, int w, boolean propagate, int event_mask, XAnyEvent event);
	public static final synchronized native int XmCreateCascadeButton (int parent, byte [] name, int [] arglist, int argcount);
	public static final synchronized native int XmCreateDrawnButton (int parent, byte [] name, int [] arglist, int argcount);
	public static final synchronized native int XmCreateRowColumn (int parent, byte [] name, int [] arglist, int argcount);
	public static final synchronized native int XmCreateScrolledWindow (int parent, byte [] name, int [] arglist, int argcount);
	public static final synchronized native int XmGetFocusWidget (int widget);
	public static final synchronized native void XmListAddItemsUnselected (int list, int xmStringTable, int item_count, int position);
	public static final synchronized native void XmListDeleteItem (int list, int item);
	public static final synchronized native void XmListDeselectItem (int list, int xmString);
	public static final synchronized native void XmListSelectItem (int list, int xmString, boolean notify);
	public static final synchronized native int XmPushButtonWidgetClass ();
	public static final synchronized native int XmStringLineCount (int xmString);
	public static final synchronized native boolean XmTextRemove (int widget);
	public static final synchronized native int XtAppSetErrorHandler (int app_context, int handler);
	public static final synchronized native int XtAppSetWarningHandler (int app_context, int handler);
	public static final synchronized native void XtCallActionProc (int widget, byte [] action, XAnyEvent event, byte [] params, int num_params);
	public static final synchronized native void XtCloseDisplay (int display);
	public static final synchronized native int XtCreateWidget (byte [] name, int widgetClass, int parent, int [] argList, int argCount);
	public static final synchronized native void XtRemoveCallback (int widget, int callback_name, int callback, int client_data);
	public static final synchronized native void XtRemoveEventHandler (int widget, int event_mask, boolean nonmaskable, int proc, int client_data);
	public static final synchronized native int XtScreen (int widget);
	*/
public static final synchronized native int OverrideShellWidgetClass ();
public static final synchronized native int ShellWidgetClass ();
public static final synchronized native int TopLevelShellWidgetClass ();
public static final synchronized native int TransientShellWidgetClass ();
public static final synchronized native int XAllocColor (int display, int colormap, XColor color);
public static final synchronized native void XBell (int display, int ms);
public static final synchronized native int XBitmapBitOrder (int display);
public static final synchronized native int XBlackPixel (int display, int screenNum);
public static final synchronized native int XChangeActivePointerGrab(int display, int event_mask, int cursor, int time);
public static final synchronized native int XChangeGC (int display, int gc, int valuemask, XGCValues values);
public static final synchronized native void XChangeWindowAttributes (int display, int window, int mask, XSetWindowAttributes attributes);
public static final synchronized native boolean XCheckMaskEvent (int display, int mask, XAnyEvent event);
public static final synchronized native boolean XCheckWindowEvent (int display, int window, int mask, XAnyEvent event);
public static final synchronized native void XClearArea (int display, int window, int x, int y, int width, int height, boolean exposures);
public static final synchronized native void XClipBox (int region, XRectangle rectangle);
public static final synchronized native void XCopyArea (int display, int src, int dest, int gc, int src_x, int src_y, int width, int height, int dest_x, int dest_y);
public static final synchronized native void XCopyPlane (int display, int src, int dest, int gc, int src_x, int src_y, int width, int height, int dest_x, int dest_y, int plane);
public static final synchronized native int XCreateBitmapFromData (int display, int drawable, byte [] data, int width, int height);
public static final synchronized native int XCreateFontCursor (int display, int shape);
public static final synchronized native int XCreateGC (int display, int window, int mask, XGCValues values);
public static final synchronized native int XCreateImage (int display, int visual, int depth, int format, int offset, int data, int width, int height, int bitmap_pad, int bytes_per_line);
public static final synchronized native int XCreatePixmap (int display, int drawable, int width, int height, int depth);
public static final synchronized native int XCreatePixmapCursor (int display, int source, int mask, XColor foreground_color, XColor background_color, int x, int y);
public static final synchronized native int XCreateRegion ();
public static final synchronized native int XDefaultColormap (int display, int screen_number);
public static final synchronized native int XDefaultDepthOfScreen (int screen);
public static final synchronized native int XDefaultRootWindow (int display);
public static final synchronized native int XDefaultScreen (int display);
public static final synchronized native int XDefaultScreenOfDisplay (int display);
public static final synchronized native int XDefaultVisual (int display, int screen_number);
public static final synchronized native void XDefineCursor (int display, int window, int cursor);
public static final synchronized native int XDestroyImage(int ximage);
public static final synchronized native void XDestroyRegion (int region);
public static final synchronized native int XDisplayHeight (int display, int screen);
public static final synchronized native int XDisplayHeightMM (int display, int screen);
public static final synchronized native int XDisplayWidth (int display, int screen);
public static final synchronized native int XDisplayWidthMM (int display, int screen);
public static final synchronized native void XDrawArc (int display, int drawable, int gc, int x1, int y1, int x2, int y2, int a1, int a2);
public static final synchronized native void XDrawLine (int display, int drawable, int gc, int x1, int y1, int x2, int y2);
public static final synchronized native void XDrawLines (int display, int drawable, int gc, short[] xPoints, int nPoints, int mode);
public static final synchronized native void XDrawRectangle (int display, int drawable, int gc, int x, int y, int width, int height);
public static final synchronized native boolean XEmptyRegion (int region);
public static final synchronized native boolean XEqualRegion (int region1, int region2);
public static final synchronized native void XFillArc (int display, int drawable, int gc, int x1, int y1, int x2, int y2, int a1, int a2);
public static final synchronized native int XFillPolygon (int display, int drawable, int gc, short[] xPoints, int nPoints, int mode, int style);
public static final synchronized native void XFillRectangle (int display, int drawable, int gc, int x, int y, int width, int height);
public static final synchronized native boolean XFilterEvent (XAnyEvent event, int window);
public static final synchronized native void XFlush (int display);
public static final synchronized native int XFontsOfFontSet (int fontSet, int[] fontStructs, int[] fontNames);
public static final synchronized native int XFree (int address);
public static final synchronized native int XFreeColors (int display, int colormap, int [] pixels, int npixels, int planes);
public static final synchronized native void XFreeCursor (int display, int pixmap);
public static final synchronized native void XFreeFontNames(int list);
public static final synchronized native void XFreeFont(int display, int font_struct);
public static final synchronized native void XFreeFontSet(int display, int font_set);
public static final synchronized native void XFreeGC (int display, int gc);
public static final synchronized native void XFreePixmap (int display, int pixmap);
public static final synchronized native int XGetGCValues (int display, int gc, int valuemask, XGCValues values);
public static final synchronized native int XGetGeometry (int display, int drawable, int [] root_return, int [] x_return, int [] y_return, int [] width_return, int [] height_return, int [] border_width_return, int [] depth_return);
public static final synchronized native int XGetImage (int display, int drawable, int x, int y, int width, int height, int plane_mask, int format);
public static final synchronized native int XGetInputFocus (int display, int [] window, int [] revert);
public static final synchronized native boolean XGetWindowAttributes (int display, int window, XWindowAttributes attributes);
public static final synchronized native int XGrabKeyboard (
	int display, 
	int grabWindow,
	int ownerEvents,
	int pointerMode,
	int keyboardMode,
	int time);
public static final synchronized native int XGrabPointer (
	int display, 
	int grabWindow,
	int ownerEvents,
	int eventMask,
	int pointerMode,
	int keyboardMode,
	int confineToWindow,
	int cursor,
	int time);
public static final synchronized native int XInitThreads ();	
public static final synchronized native int XInternAtom( int display, byte [] name, boolean ifExists );
public static final synchronized native int XKeysymToString (int keysym);
public static final synchronized native int XListFonts(int display, byte[] pattern, int maxnames, int[] actual_count_return);
public static final synchronized native int XListProperties(int display, int window, int[] num_prop_return);
public static final synchronized native int XLookupString (XKeyEvent event, byte [] string, int size, int [] keysym, int [] status);
public static final synchronized native int XLowerWindow (int display, int window);
public static final synchronized native boolean XPointInRegion (int region, int x, int y);
public static final synchronized native int XPutImage (int display, int drawable, int gc, int image, int srcX, int srcY, int destX, int destY, int width, int height);
public static final synchronized native int XQueryColor (int display, int colormap, XColor color);
public static final synchronized native int XQueryPointer (
	int display, 
	int window, 
	int [] root,
	int [] child,
	int [] rootX,
	int [] rootY,
	int [] windowX,
	int [] windowY,
	int [] mask);
public static final synchronized native int XQueryTree (int display, int window, int [] root_return, int [] parent_return, int [] children_return, int [] nChildren_return);
public static final synchronized native int XRaiseWindow (int display, int window);
public static final synchronized native int XReconfigureWMWindow (int display, int window, int screen, int valueMask, XWindowChanges values);
public static final synchronized native int XRectInRegion (int region, int x, int y, int width, int height);
public static final synchronized native void XSetBackground (int display, int gc, int background);
public static final synchronized native void XSetClipMask (int display, int gc, int pixmap);
public static final synchronized native void XSetClipRectangles (int display, int gc, int clip_x_origin, int clip_y_origin, XRectangle rectangles, int n, int ordering);
public static final synchronized native int XSetDashes (int display, int gc, int dash_offset, byte[] dash_list, int n);
public static final synchronized native int XSetErrorHandler (int handler);
public static final synchronized native void XSetFillStyle (int display, int gc, int fill_style);
public static final synchronized native int XSetFont (int display, int gc, int font);
public static final synchronized native void XSetForeground (int display, int gc, int foreground);
public static final synchronized native void XSetFunction (int display, int gc, int function);
public static final synchronized native void XSetGraphicsExposures (int display, int gc, boolean graphics_exposures);
public static final synchronized native int XSetInputFocus (int display, int window, int revert, int time);
public static final synchronized native int XSetLineAttributes (int display, int gc, int lineWidth, int lineStyle, int capStyle, int joinStyle);
public static final synchronized native void XSetRegion (int display, int gc, int region);
public static final synchronized native void XSetStipple (int display, int gc, int pixmap);
public static final synchronized native void XSetSubwindowMode (int display, int gc, int subwindow_mode);
public static final synchronized native void XSetWindowBorderWidth (int display, int window, int width);
public static final synchronized native void XSubtractRegion (int sra, int srb, int dr_return);
public static final synchronized native void XSync (int display, boolean discard);
public static final synchronized native int XSynchronize (int display, boolean onoff);
public static final synchronized native void XUndefineCursor (int display, int window);
public static final synchronized native int XUngrabKeyboard (int display, int time);
public static final synchronized native int XUngrabPointer (int display, int time);
public static final synchronized native void XUnionRectWithRegion (XRectangle rectangle, int src_region, int dest_region_return);
public static final synchronized native void XUnionRegion (int sra, int srb, int dr_return);
public static final synchronized native int XWarpPointer (int display, int sourceWindow, int destWindow, int sourceX, int sourceY, int sourceWidth, int sourceHeight, int destX, int destY);
public static final synchronized native int XWhitePixel (int display, int screenNum);
public static final synchronized native void XWithdrawWindow (int display, int window, int screen);
public static final synchronized native void XmAddWMProtocolCallback (int shell, int protocol, int callback, int closure);
public static final synchronized native void XmChangeColor (int widget, int pixel);
public static final synchronized native int XmClipboardCopy(int display, int window, int item_id, byte[] format_name, byte[] buffer, int length, int private_id, int[] data_id);
public static final synchronized native int XmClipboardEndCopy(int display, int window, int item_id);
public static final synchronized native int XmClipboardStartCopy(int display, int window, int clip_label, int timestamp, int widget, int callback, int[] item_id);
public static final synchronized native int XmClipboardInquireLength(int display, int widget, byte[] format_name, int[] length);
public static final synchronized native int XmClipboardInquireFormat(int display, int window, int index, byte[] format_name_buf, int buffer_len, int[]copied_len);
public static final synchronized native int XmClipboardInquireCount(int display, int window, int[] count, int[] max_format_name_length);
public static final synchronized native int XmClipboardStartRetrieve(int display, int window, int timestamp);
public static final synchronized native int XmClipboardRetrieve(int display, int window, byte[] format_name, byte[] buffer, int length, int[] num_bytes, int[] private_id);
public static final synchronized native int XmClipboardEndRetrieve(int display, int window);
public static final synchronized native void XmComboBoxAddItem(int widget, int xmString, int position, boolean unique);
public static final synchronized native void XmComboBoxDeletePos(int widget, int position);
public static final synchronized native void XmComboBoxSelectItem(int widget, int xmString);
public static final synchronized native int XmCreateArrowButton (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateCascadeButtonGadget (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateComboBox(int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateDialogShell (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateDrawingArea (int parent, byte [] name, int [] arglist, int argcount);
//public static final synchronized native int XmCreateDrawnButton (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateErrorDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateFileSelectionDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateForm (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateFrame (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateInformationDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateLabel (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateList (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateMainWindow (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateMenuBar (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateMessageDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreatePopupMenu (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreatePulldownMenu (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreatePushButton (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreatePushButtonGadget (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateQuestionDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateScale (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateScrollBar (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateScrolledList (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateScrolledText (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateSeparator (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateSeparatorGadget (int parent, byte [] name, int [] arglist, int argcount);
//public static final synchronized native int XmCreateSimpleSpinBox (int parent, byte [] name, int [] arglist, int argcount);
//public static final synchronized native int XmCreateSpinBox (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateTextField (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateToggleButton (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateToggleButtonGadget (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XmCreateWarningDialog (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native boolean XmDestroyPixmap (int screen, int pixmap);
public static final synchronized native void XmDragCancel(int dragcontext);
public static final synchronized native int XmDragStart(int widget, XAnyEvent event, int[] arglist, int argcount);
public static final synchronized native void XmDropSiteRegister(int widget, int [] arglist, int argcount);
public static final synchronized native void XmDropSiteUnregister(int widget);
public static final synchronized native void XmDropSiteUpdate(int widget, int [] arglist, int argcount);
public static final synchronized native void XmDropTransferAdd(int drop_transfer, int [] transfers, int num_transfers);
public static final synchronized native int XmDropTransferStart(int widget, int [] arglist, int argcount);
public static final synchronized native int XmFileSelectionBoxGetChild (int widget, int child);
public static final synchronized native int XmFontListAppendEntry (int oldList, int entry);
public static final synchronized native int XmFontListCopy (int fontlist);
public static final synchronized native void XmFontListEntryFree  (int[] entry);
public static final synchronized native int XmFontListEntryGetFont (int entry, int[] type_return);
public static final synchronized native int XmFontListEntryLoad (int display, byte [] fontName, int type, byte[] tag);
public static final synchronized native void XmFontListFree (int list);
public static final synchronized native void XmFontListFreeFontContext (int context);
public static final synchronized native boolean XmFontListInitFontContext (int[] context,int fontList);
public static final synchronized native int XmFontListNextEntry (int context); 
public static final synchronized native int XmGetAtomName (int display, int atom);
public static final synchronized native int XmGetDragContext (int widget, int timestamp);
public static final synchronized native int XmGetFocusWidget (int widget);
public static final synchronized native int XmGetPixmap( int screen, byte [] name, int fgPixel, int bgPixel );
public static final synchronized native int XmGetPixmapByDepth (int screen, byte [] image_name, int foreground, int background, int depth);
public static final synchronized native int XmGetXmDisplay (int display);
public static final synchronized native int XmImMbLookupString (int widget, XKeyEvent event, byte [] string, int size, int [] keysym, int [] status);
public static final synchronized native int XmInternAtom (int display, byte [] name, boolean only_if_exists);
public static final synchronized native void XmListAddItemUnselected (int list, int xmString, int position);
public static final synchronized native void XmListDeleteAllItems (int list);
public static final synchronized native void XmListDeleteItemsPos (int list, int item_count, int position);
public static final synchronized native void XmListDeletePos (int list, int position);
public static final synchronized native void XmListDeletePositions (int list, int [] position_list, int position_count);
public static final synchronized native void XmListDeselectAllItems (int list);
public static final synchronized native void XmListDeselectPos (int list, int position);
public static final synchronized native int XmListGetKbdItemPos (int list);
public static final synchronized native boolean XmListGetSelectedPos (int list, int [] positions, int [] count);
public static final synchronized native int XmListItemPos (int list, int xmString);
public static final synchronized native boolean XmListPosSelected (int list, int position);
public static final synchronized native void XmListReplaceItemsPosUnselected (int list, int [] new_items, int item_count, int position);
public static final synchronized native void XmListSelectPos (int list, int position, boolean notify);
public static final synchronized native boolean XmListSetKbdItemPos (int list, int position);
public static final synchronized native void XmListSetPos (int list, int position);
public static final synchronized native void XmListUpdateSelectedList (int list);
public static final synchronized native void XmMainWindowSetAreas (int widget, int menu, int command, int hscroll, int vscroll, int wregion);
public static final synchronized native int XmMenuShellWidgetClass ();
public static final synchronized native int XmMessageBoxGetChild (int widget, int child);
public static final synchronized native int XmParseMappingCreate (int [] argList, int argCount);
public static final synchronized native void XmParseMappingFree (int parseMapping);
public static final synchronized native boolean XmProcessTraversal (int widget, int dir);
public static final synchronized native int XmRenderTableAddRenditions(int oldTable, int[] renditions, int renditionCount, int mergeMode);
public static final synchronized native void XmRenderTableFree(int renderTable);
public static final synchronized native int XmRenditionCreate(int widget, byte[] tag, int[] argList, int argCount);
public static final synchronized native void XmRenditionFree(int rendition);
public static final synchronized native boolean XmStringCompare (int xmString1, int xmString2);
public static final synchronized native int XmStringComponentCreate (int type, int length, byte[] value);
public static final synchronized native int XmStringCreate (byte [] string, byte [] charset);
public static final synchronized native int XmStringCreateLocalized (byte [] string);
//public static final synchronized native int XmStringCreateLtoR (byte [] string, byte [] charset);
public static final synchronized native void XmStringDraw (int display, int window, int renderTable, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip);
public static final synchronized native void XmStringDrawImage (int display, int window, int renderTable, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip);
public static final synchronized native void XmStringDrawUnderline (int display, int window, int fontlist, int xmString, int gc, int x, int y, int width, int align, int lay_dir, XRectangle clip, int xmStringUnderline);
public static final synchronized native boolean XmStringEmpty (int s1);
public static final synchronized native void XmStringFree (int xmString);
//public static final synchronized native boolean XmStringGetLtoR (int xmString, byte [] charset, int [] text);
public static final synchronized native int XmStringGenerate(byte[] text, byte[] tag, int type, byte[] rendition);
public static final synchronized native int XmStringHeight (int fontList, int xmString);
public static final synchronized native int XmStringParseText (byte[] text, int textEnd, byte [] tag, int tagType, int [] parseTable, int parseCount, int callData);
public static final synchronized native int XmStringWidth (int fontList, int xmString);
public static final synchronized native int XmStringUnparse (int xmString, byte [] tag, int tagType, int outputType, int [] parseTable, int parseCount, int parseModel);
public static final synchronized native int XmTabCreate(int value, byte units, byte offsetModel, byte alignment, byte[] decimal);
public static final synchronized native void XmTabFree(int tab);
public static final synchronized native void XmTabListFree(int tabList);
public static final synchronized native int XmTabListInsertTabs(int oldList, int[] tabs, int tab_count, int position);
public static final synchronized native void XmTextClearSelection (int widget, int time);
public static final synchronized native boolean XmTextCopy (int widget, int time);
public static final synchronized native boolean XmTextCut (int widget, int time);
public static final synchronized native void XmTextDisableRedisplay (int widget);
public static final synchronized native void XmTextEnableRedisplay (int widget);
public static final synchronized native int XmTextGetInsertionPosition (int widget);
public static final synchronized native int XmTextGetLastPosition (int widget);
public static final synchronized native int XmTextGetMaxLength (int widget);
public static final synchronized native int XmTextGetSelection (int widget);
public static final synchronized native boolean XmTextGetSelectionPosition (int widget, int [] left, int [] right);
public static final synchronized native int XmTextGetString (int widget);
public static final synchronized native int XmTextGetSubstring (int widget, int start, int num_chars, int buffer_size, byte [] buffer);
public static final synchronized native int XmTextGetSubstringWcs (int widget, int start, int num_chars, int buffer_size, char [] buffer);
public static final synchronized native void XmTextInsert (int widget, int position, byte [] value);
public static final synchronized native boolean XmTextPaste (int widget);
public static final synchronized native boolean XmTextPosToXY (int widget, int position, short [] x, short [] y);
public static final synchronized native void XmTextReplace (int widget, int from_pos, int to_pos, byte [] value);
public static final synchronized native void XmTextScroll (int widget, int lines);
public static final synchronized native void XmTextSetEditable (int widget, boolean editable);
public static final synchronized native void XmTextSetHighlight (int widget, int left, int right, int mode);
public static final synchronized native void XmTextSetInsertionPosition (int widget, int position);
public static final synchronized native void XmTextSetMaxLength (int widget, int max_length);
public static final synchronized native void XmTextSetSelection (int widget, int first, int last, int time);
public static final synchronized native void XmTextSetString (int widget, byte [] value);
public static final synchronized native void XmTextShowPosition (int widget, int position);
public static final synchronized native void XmUpdateDisplay (int widget);
public static final synchronized native boolean XmWidgetGetDisplayRect (int region, XRectangle rectangle);
//public static final synchronized native int XmbLookupString (int ic, XKeyEvent event, byte [] string, int size, int [] keysym, int [] status);
public static final synchronized native int XmbTextListToTextProperty (int display, int list, int count, int style, XTextProperty text_prop_return);
public static final synchronized native int XmbTextPropertyToTextList (int display, XTextProperty text_prop, int[] list_return, int[] count_return);

public static final synchronized native void XtAddCallback (int widget, int callback_name, int callback, int client_data);
public static final synchronized native void XtAddEventHandler (int widget, int event_mask, boolean nonmaskable, int proc, int client_data);
public static final synchronized native void XtAddExposureToRegion (int event, int region);
public static final synchronized native int XtAppAddTimeOut (int app_context, int interval, int proc, int client_data);
public static final synchronized native int XtAppCreateShell (
	byte [] appName, 
	byte [] appClass, 
	int widgetClass, 
	int display,
	int [] argList,
	int argCount);
public static final synchronized native int XtAppGetSelectionTimeout (int appContext);
public static final synchronized native void XtAppNextEvent (int appContext, XAnyEvent event);
public static final synchronized native boolean XtAppPeekEvent (int appContext, XAnyEvent event);
public static final synchronized native int XtAppPending (int appContext);
public static final synchronized native void XtAppProcessEvent (int appContext, int inputMask);
public static final synchronized native int XtAppSetErrorHandler (int app_context, int msg_handler);
public static final synchronized native void XtAppSetSelectionTimeout (int appContext, int timeout);
public static final synchronized native int XtAppSetWarningHandler (int app_context, int msg_handler);
public static final synchronized native int XtBuildEventMask (int widget);
public static final synchronized native void XtCallActionProc (int widget, byte []  action, XAnyEvent event, int [] params, int num_params);
public static final synchronized native int XtClass (int widget);
public static final synchronized native void XtConfigureWidget (int widget, int x, int y, int width, int height, int borderWidth);
public static final synchronized native int XtCreateApplicationContext ();
public static final synchronized native int XtCreatePopupShell (byte [] name, int widgetClass, int parent, int [] argList, int argCount);
public static final synchronized native void XtDestroyApplicationContext (int appContext);
public static final synchronized native void XtDestroyWidget (int widget);
public static final synchronized native boolean XtDispatchEvent (XAnyEvent event);
public static final synchronized native int XtDisplay (int widget);
public static final synchronized native int XtDisplayToApplicationContext (int display);
public static final synchronized native void XtFree (int ptr);
public static final synchronized native int XtGetMultiClickTime (int display);
public static final synchronized native void XtGetValues (int widget, int [] argList, int numArgs);
public static final synchronized native boolean XtIsManaged (int widget);
public static final synchronized native boolean XtIsRealized (int widget);
public static final synchronized native boolean XtIsSubclass (int widget, int widgetClass);
public static final synchronized native boolean XtIsTopLevelShell (int widget);
public static final synchronized native boolean XtIsWidget (int widget);
public static final synchronized native int XtLastTimestampProcessed (int display);
public static final synchronized native int XtMalloc (int size);
public static final synchronized native void XtManageChild (int widget);
public static final synchronized native void XtMapWidget (int widget);
public static final synchronized native void XtMoveWidget (int widget, int x, int y);
public static final synchronized native int XtOpenDisplay (
	int xtAppContext, 
	byte [] displayName, 
	byte [] applicationName, 
	byte [] applicationClass,
	int options, 
	int numOptions, 
	int [] argc, 
	int argv);
public static final synchronized native void XtOverrideTranslations (int w, int translations);
public static final synchronized native int XtParent (int widget);
public static final synchronized native int XtParseTranslationTable (byte [] string);
public static final synchronized native void XtPopdown (int widget);
public static final synchronized native void XtPopup (int widget, int flags);
public static final synchronized native int XtQueryGeometry (int widget, XtWidgetGeometry intended, XtWidgetGeometry preferred_return);
public static final synchronized native void XtRealizeWidget (int widget);
public static final synchronized native void XtRemoveTimeOut (int id);
public static final synchronized native void XtResizeWidget (int widget, int width, int height, int borderWidth);
public static final synchronized native void XtResizeWindow (int widget);
public static final synchronized native int XtSetLanguageProc (int appContext, int languageProc, int pointer);
public static final synchronized native void XtSetMappedWhenManaged (int widget, boolean flag);
public static final synchronized native void XtSetValues (int widget, int [] argList, int numArgs);
public static final synchronized native void XtToolkitInitialize ();
public static final synchronized native void XtTranslateCoords (int widget, short x, short y, short [] root_x, short [] root_y);
public static final synchronized native void XtUnmanageChild (int widget);
public static final synchronized native void XtUnmapWidget (int widget);
public static final synchronized native int XtWindow (int widget);
public static final synchronized native int XtWindowToWidget (int display, int widget);

static int malloc (String name, int length) {
	int strLen = name.length ();
	if (NextResourceStart + strLen + 2 > RESOURCE_START + RESOURCE_LENGTH) {
		System.out.println ("*** Warning : SWT - Resource overrun.  Increase OS.RESOURCE_LENGTH.");
		System.out.println ("*** Warning : Exiting ...");
		System.exit (0);
	}
	char [] unicode = new char [strLen];
	name.getChars (0, strLen, unicode, 0);
	byte[] buffer = new byte [strLen + 2];
	buffer [0] = (byte) length;
	for (int i = 0; i < strLen; i++) {
		buffer [i+1] = (byte) unicode[i];
	}
	OS.memmove (NextResourceStart, buffer, strLen + 2);
	int result = NextResourceStart + 1;
	NextResourceStart += strLen + 2;
	return result;
}

public static final native void memmove (int dest, XImage src, int count);
public static final native void memmove (int dest, XmDragProcCallback src, int count);
public static final native void memmove (int dest, XmTextBlockRec src, int count);
public static final native void memmove (int dest, XmTextVerifyCallbackStruct src, int count);
public static final native void memmove (int dest, byte [] src, int count);
public static final native void memmove (int dest, char [] src, int count);
public static final native void memmove (int dest, int [] src, int count);
public static final native void memmove (Visual dest, int src, int count);
public static final native void memmove (XButtonEvent dest, int src, int count);
public static final native void memmove (int dest, XButtonEvent src, int count);
public static final native void memmove (XCharStruct dest, int src, int count);
public static final native void memmove (XConfigureEvent dest, int src, int count);
public static final native void memmove (XCrossingEvent dest, int src, int count);
public static final native void memmove (XExposeEvent dest, int src, int count);
public static final native void memmove (XFocusChangeEvent dest, int src, int count);
public static final native void memmove (XFontStruct dest, int src, int count);
public static final native void memmove (XImage dest, int src, int count);
public static final native void memmove (XKeyEvent dest, int src, int count);
public static final native void memmove (XKeyEvent dest, XAnyEvent src, int count);
public static final native void memmove (XMotionEvent dest, int src, int count);
public static final native void memmove (XmAnyCallbackStruct dest, int src, int count);
public static final native void memmove (XmDragProcCallback dest, int src, int count);
public static final native void memmove (XmDropFinishCallback dest, int src, int count);
public static final native void memmove (XmDropProcCallback dest, int src, int count);
public static final native void memmove (XmTextBlockRec dest, int src, int count);
public static final native void memmove (XmTextVerifyCallbackStruct dest, int src, int count);
public static final native void memmove (byte [] dest, int src, int count);
public static final native void memmove (char [] dest, int src, int count);
public static final native void memmove (int [] dest, int src, int count);
public static final native int strlen (int string);
public static final synchronized native int XmCreateDrawnButton (int parent, byte [] name, int [] arglist, int argcount);
public static final synchronized native int XCheckIfEvent (int display, XAnyEvent event_return, int predicate, int arg);
public static final synchronized native boolean XtToolkitThreadInitialize ();
public static final synchronized native int Call (int proc, int arg1, int arg2);
public static final synchronized native int XSetIOErrorHandler (int handler);
public static final synchronized native boolean XmTextFieldPaste (int widget);

/*
 * ======== Start of printing constants and functions ========
 */
	public static final byte XPJobAttr = 1;
	public static final byte XPDocAttr = 2;
	public static final byte XPPrinterAttr = 4;
	public static final byte XPAttrMerge = 2;
	public static final byte XPSpool = 1;
	public static final int CopyFromParent = 0;

public static final synchronized native int XpCreateContext(int display, byte [] printer_name);
public static final synchronized native int XpGetPrinterList(int display, byte [] printer_name, int [] list_count);
public static final synchronized native void XpFreePrinterList(int printer_list);
public static final synchronized native int XpGetAttributes(int display, int print_context, byte type);
public static final synchronized native void XpSetAttributes(int display, int print_context, byte type, byte [] pool, byte replacement_rule);
public static final synchronized native int XpGetOneAttribute(int display, int print_context, byte type, byte [] attribute_name);
public static final synchronized native void XpSetContext(int display, int print_context);    
public static final synchronized native int XpGetScreenOfContext(int display, int print_context);
public static final synchronized native void XpDestroyContext(int display, int print_context);
public static final synchronized native int XpGetPageDimensions(int display, int print_context, short [] width, short [] height, XRectangle reproducible_area);
public static final synchronized native void XpStartJob(int display, byte save_data);
public static final synchronized native void XpStartPage(int display, int window);
public static final synchronized native void XpEndPage(int display);
public static final synchronized native void XpEndJob(int display);
public static final synchronized native void XpCancelJob(int display, boolean discard);
public static final synchronized native int XpQueryVersion(int display, short[] major_version, short[] minor_version);
public static final synchronized native int XDefaultGCOfScreen(int screen);
public static final synchronized native int XDefaultColormapOfScreen(int screen);
public static final synchronized native int XRootWindowOfScreen(int screen);
public static final synchronized native int XScreenNumberOfScreen(int screen);
public static final synchronized native int XCreateWindow(int display, int parent, int x, int y, int width, int height,
		int border_width, int depth, int clazz, int visual, long value_mask, int attributes);	
public static final synchronized native void XDestroyWindow(int display, int w);
public static final native int getenv(byte[] name);
public static final synchronized native int XOpenDisplay(byte[] display_name);
public static final synchronized native void XCloseDisplay(int display);

/*
 * ======== End of printing constants and functions ========
 */

public static final native int pipe (int [] filedes);
public static final native int read (int filedes, byte [] buf, int nbyte);
public static final native int write (int filedes, byte [] buf, int nbyte);
public static final native int close (int filedes);
public static final native int select (int n, byte [] readfds, byte [] writefds, byte [] exceptfds, int [] timeout);
public static final native void FD_ZERO (byte [] fd_set);
public static final native void FD_SET (int fd, byte [] fd_set);
public static final native boolean FD_ISSET (int fd, byte [] fd_set);
//public static final native int FD_SETSIZE ();
//public static final native int NFDBITS ();
public static final native int fd_set_sizeof ();
public static final synchronized native int ConnectionNumber (int display);
public static final synchronized native int XtAppAddInput (int app_context, int source, int condition, int proc, int client_data);
public static final synchronized native void XtRemoveInput (int id);
//	public static final int XtInputNoneMask = 0;
	public static final int XtInputReadMask = 1;
//	public static final int XtInputWriteMask = 2;
//	public static final int XtInputExceptMask = 4;

public static final synchronized native int XLoadQueryFont (int display, byte[] name);
public static final synchronized native int XmFontListEntryCreate (byte[] tag, int type, int font);

public static final synchronized native int XmImGetXIC (int widget, int input_policy, int[] args, int num_args);
public static final synchronized native int XmImGetXIM (int widget);
public static final synchronized native void XmImRegister (int widget, int reserved);
public static final synchronized native int XmImSetFocusValues (int widget, int[] args, int num_args);
//public static final synchronized native int XmImVaSetFocusValues(int widget, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9);
public static final synchronized native int XmImSetValues (int widget, int[] args, int num_args);
public static final synchronized native void XmImUnregister (int widget);
public static final synchronized native void XmImUnsetFocus (int widget);
//public static final synchronized native void XSetICFocus (int ic);
//public static final synchronized native void XUnsetICFocus (int ic);
//public static final synchronized native int XCreateIC (int im, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7);
//public static final synchronized native int XSetICValues (int ic, int arg1, int arg2, int arg3);
//public static final synchronized native int XGetICValues (int ic, int arg1, int arg2, int arg3);
//public static final synchronized native int XGetIMValues (int im, int arg1, int arg2, int arg3);
public static final native void memmove (int dest, short [] src, int count);
//public static final native void memmove (char[] dest, int src, int count);
//public static final native void memmove ( int dest, char[] src,int count);

public static final native int nl_langinfo (int item);
public static final native int iconv_open (byte[] tocode, byte[] fromcode);
public static final native int iconv_close (int cd);
public static final native int iconv (int cd, int[] inBuf, int[] inBytesLeft, int[] outBuf, int[] outBytesLeft);
public static final native int MB_CUR_MAX ();
public static final native int setlocale (int category, byte[] locale);
static final native int setResourceMem (int start, int end);

public static final synchronized native int XCreateFontSet (int display, byte [] base_font_name_list, int [] missing_charset_list_return, int [] missing_charset_count_return, int [] def_string_return);
public static final synchronized native int XLocaleOfFontSet (int fontSet);
public static final synchronized native void XFreeStringList (int list);

public static final synchronized native void XtInsertEventHandler (int w, int event_mask, boolean nonmaskable, int proc, int client_data, int position);
//public static final synchronized native void XmAddToPostFromList (int menu, int post_from_list);
//public static final synchronized native void XmRemoveFromPostFromList (int menu, int post_from_list);
//public static final synchronized native void XmMenuPosition (int menu, int event);
public static final synchronized native void _XmSetMenuTraversal (int menu, boolean traversal);
public static final synchronized native int XEventsQueued (int display, int mode);
public static final native void memmove (int dest, XExposeEvent src, int count);
public static final synchronized native void XtAppSetFallbackResources (int app_context, int specification_list);

}
